using System;

namespace UnityEditor.HiveEditor
{
    /// <summary>
    /// Hive Post-Build 단계에서 호출될 정적 메서드에 부여.
    /// </summary>
    [AttributeUsage(AttributeTargets.Method, AllowMultiple = false)]
    public sealed class HivePostBuildAttribute : Attribute
    {
        public HivePostBuildAttribute(int order = 0) => Order = order;
        public int Order { get; }
    }
}